using Microsoft.Azure.WebJobs;
using Microsoft.Azure.WebJobs.Host;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.BatchService.Interface;

namespace VA.PPMS.IWS.Functions
{
    public static class CrResponseQueueTrigger
    {
        [FunctionName("CrResponseQueueTrigger")]
        public static async Task Run([QueueTrigger("%PpmsCreateResponse_ResponseQueueName%", Connection = "AzureWebJobsStorage")]
            string crResponseQueueItem,
            [Inject] IBatchService batchService,
            TraceWriter log)
        {
            try
            {
                log.Info($"Start CrResponseQueueTrigger function processed function processed: {crResponseQueueItem}");

                await batchService.ProcessBatch(crResponseQueueItem);

                log.Info($"End CrResponseQueueTrigger function processed function processed: {crResponseQueueItem}");
            }
            catch (Exception ex)
            {
                log.Error($"There was a problem with CrResponseQueueTrigger Processing for Provider: {crResponseQueueItem}.", ex);
            }
        }
    }
}